Considrese el siguiente tipo para representar Imgenes monocromas mediante lneas de pixeles:

> type Pixel  = Int
> type Linea  = [Pixel]
> type Imagen = [Linea]

donde un pixel negro se representa con el valor 1 y uno blanco con el 0.

Por ejemplo

> tringulo :: Imagen
> tringulo = [ [1,0,0,0],
>               [1,1,0,0],
>               [1,1,1,0],
>               [1,1,1,1] ]


A)

Escribe una funcion intercalar :: a -> [a] -> [a] que inserte un elemento entre cada
dos elementos de una lista. Por ejemplo, 

? intercalar 1 [2,3,4] 
[2, 1, 3, 1, 4] 

> intercalar :: a -> [a] -> [a]
> intercalar x []     = []
> intercalar x [y]    = [y]
> intercalar x (y:ys) = y:x:intercalar x ys

Escribe una funcin invertir :: [a] -> [a] para invertir una lista. Por ejemplo, 
? invertir [2,3,4]
[4,3,2]

B)

Escribe una funcin pinta :: Imagen -> String que devuelva la cadena de caracteres 
que representa una figura. Los ceros deben ser reemplazados por el caracter punto, los unos por el caracter 'x' y debe aparecer 
un salto de lnea (caracter '\n') entra cada dos lneas de la figuras, es decir, pinta tringulo --> "X...\nXX..\nXXX.\nXXXX"


? pinta tringulo
X...
XX..
XXX.
XXXX  


> pinta :: Imagen -> String
> pinta = concat . intercalar "\n" . map (map substituir)
>  where substituir 0 = '.'
>        substituir 1 = 'X'
>        substituir _ = error "pixel erroneo"




Escribe funciones que reflejen horizontal, vertical y en ambas direcciones una figura.
Por ejemplo:

> girarH, girarV, girar :: Imagen -> Imagen
> girarH = map reverse
> girarV = reverse
> girar = girarH . girarV
   

? (pinta . girarH) tringulo
...X
..XX
.XXX
XXXX

? (pinta . girarV) tringulo
XXXX
XXX.
XX..
X...

? (pinta . girar) tringulo
XXXX
.XXX
..XX
...X  

C)
Escribe dos operadores que permitan obtener una figura al unir horizontal y 
verticalmente dos figuras. Puedes suponer que las figuras a unir tienen el mismo
tamao.

? pinta  (tringulo >+< girar tringulo)
X...
XX..
XXX.
XXXX
XXXX
.XXX
..XX
...X

? pinta  (tringulo >-< girar tringulo)
X...XXXX
XX...XXX
XXX...XX
XXXX...X              

> -- Una figura sobre otra
> (>+<)  :: Imagen -> Imagen -> Imagen
> (>+<) = (++)

> -- Una junto a otra
> -- ambas figuras mismo alto
> (>-<)  :: Imagen -> Imagen -> Imagen
> (>-<) = zipWith (++)

Escribe una funcin negar :: Imagen -> Imagen, que obtenga la negacin de una figura

> negar :: Imagen -> Imagen
> negar = map (map inv)
>   where
>     inv ch = if ch == 1 then 0 else 1


? (pinta . negar) tringulo
.XXX
..XX
...X
....   

E) Escribe usando la funcin foldr una funcin que repita un nmero de veces dado cada elemento
 de una lista. Por ejemplo, 

? repite 3 "abc"
"aaabbbccc"

> repite :: Int -> [a] -> [a]
> repite n = foldr (\x xs -> [x| _<-[1..n]] ++ xs) []

Escribe una funcin 

> zoom :: Int -> Imagen -> Imagen
> zoom n = repite n . map (repite n)

? pinta (zoom 2 tringulo)
XX......
XX......
XXXX....
XXXX....
XXXXXX..
XXXXXX..
XXXXXXXX
XXXXXXXX  

> superponer :: Imagen -> Imagen -> Imagen
> superponer = zipWith (zipWith (<+>))
>   where 1<+> 1 = 1
>         x<+> y = x+y

> p1 = pinta  ( superponer tringulo tringulo)
> p2 = pinta  ( superponer (negar tringulo) tringulo)
